/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl;

import dev.engine_room.flywheel.api.event.EndClientResourceReloadCallback;
import dev.engine_room.flywheel.api.event.ReloadLevelRendererCallback;
import dev.engine_room.flywheel.backend.compile.FlwProgramsReloader;
import dev.engine_room.flywheel.backend.engine.uniform.Uniforms;
import dev.engine_room.flywheel.impl.BackendArgument;
import dev.engine_room.flywheel.impl.BackendManagerImpl;
import dev.engine_room.flywheel.impl.DebugModeArgument;
import dev.engine_room.flywheel.impl.FlwCommands;
import dev.engine_room.flywheel.impl.FlwImpl;
import dev.engine_room.flywheel.impl.LightSmoothnessArgument;
import dev.engine_room.flywheel.impl.mixin.fabric.ArgumentTypeInfosAccessor;
import dev.engine_room.flywheel.impl.visualization.VisualizationEventHandler;
import dev.engine_room.flywheel.lib.model.baked.PartialModelEventHandler;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import dev.engine_room.flywheel.lib.util.ResourceReloadHolder;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_1937;
import net.minecraft.class_2314;
import net.minecraft.class_3264;
import net.minecraft.class_638;
import org.jetbrains.annotations.UnknownNullability;

public final class FlywheelFabric
implements ClientModInitializer {
    private static @UnknownNullability Version version;

    public void onInitializeClient() {
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("flywheel").orElseThrow();
        version = modContainer.getMetadata().getVersion();
        FlywheelFabric.setupImpl();
        FlywheelFabric.setupLib();
        FlywheelFabric.setupBackend();
        FlwImpl.init();
    }

    private static void setupImpl() {
        ReloadLevelRendererCallback.EVENT.register(BackendManagerImpl::onReloadLevelRenderer);
        ClientTickEvents.END_CLIENT_TICK.register(minecraft -> {
            class_638 level;
            if (!minecraft.method_1493() && (level = minecraft.field_1687) != null) {
                VisualizationEventHandler.onClientTick(minecraft, (class_1937)level);
            }
        });
        ClientEntityEvents.ENTITY_LOAD.register((entity, level) -> VisualizationEventHandler.onEntityJoinLevel((class_1937)level, entity));
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, level) -> VisualizationEventHandler.onEntityLeaveLevel((class_1937)level, entity));
        ClientCommandRegistrationCallback.EVENT.register(FlwCommands::registerClientCommands);
        EndClientResourceReloadCallback.EVENT.register((minecraft, resourceManager, initialReload, error) -> BackendManagerImpl.onEndClientResourceReload(error.isPresent()));
        ArgumentTypeInfosAccessor.getBY_CLASS().put(BackendArgument.class, (class_2314<?, ?>)BackendArgument.INFO);
        ArgumentTypeInfosAccessor.getBY_CLASS().put(DebugModeArgument.class, (class_2314<?, ?>)DebugModeArgument.INFO);
        ArgumentTypeInfosAccessor.getBY_CLASS().put(LightSmoothnessArgument.class, (class_2314<?, ?>)LightSmoothnessArgument.INFO);
    }

    private static void setupLib() {
        ReloadLevelRendererCallback.EVENT.register(level -> RendererReloadCache.onReloadLevelRenderer());
        EndClientResourceReloadCallback.EVENT.register((minecraft, resourceManager, initialReload, error) -> ResourceReloadHolder.onEndClientResourceReload());
        ModelLoadingPlugin.register(ctx -> ctx.addModels(PartialModelEventHandler.onRegisterAdditional()));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)PartialModelEventHandler.ReloadListener.INSTANCE);
    }

    private static void setupBackend() {
        ReloadLevelRendererCallback.EVENT.register(level -> Uniforms.onReloadLevelRenderer());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)FlwProgramsReloader.INSTANCE);
    }

    public static Version version() {
        return version;
    }
}

